<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Creates OverView Tree hierarchy for all packages -->
	<xsl:template name="OverViewTree">
		<xsl:if test="$navbar_param">
			<xsl:call-template name="OverViewTreeNavBar">
				<xsl:with-param name="header" select="'true'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:variable name="nodeset" select="//Package"/>
		<xsl:variable name="hierarchy">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'hierarchy_for_all_packages'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
	
		<center><h2><xsl:value-of select="$hierarchy"></xsl:value-of></h2></center>
		
		<xsl:if test="$nodeset">
			<dl>
			<dt>
			<b>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'package_hierarchies'"></xsl:with-param>
			</xsl:call-template>
			</b>
			<dd>
			<xsl:for-each select="$nodeset">
				<xsl:variable name="packPath">
					<xsl:call-template name="treePathResolver">
						<xsl:with-param name="element" select="current()"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>			
				
				<a href="{$packPath}">
				<xsl:value-of select="current()/@name"></xsl:value-of>
				</a>	
				
				<xsl:if test="not(position()=last())">
					<xsl:text>, </xsl:text>
				</xsl:if>
			</xsl:for-each>
			</dd>
			</dt>
			</dl>
		</xsl:if>

		<hr/>
		<xsl:variable name="areClasses" select="//Classifier[not(@type='Interface')]"></xsl:variable>
		<xsl:variable name="areInterfaces" select="//Classifier[@type='Interface']"></xsl:variable>

		<!-- Class hierarchy -->
		<xsl:if test="$areClasses">
			<h2>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'class_hierarchy'"></xsl:with-param>
			</xsl:call-template>
			</h2>
			<xsl:for-each select="//Package | //Model">
				<!--xsl:variable name="classes" select="current()/child::Classifier[@type='Class' or @type='Struct'][not(Extends)]"></xsl:variable-->
				<xsl:variable name="classes" select="current()/child::Classifier[@type='Class' or @type='Struct'][count(Extends)=count(Extends/@doom)]"></xsl:variable>
				<xsl:if test="$classes">
					<xsl:call-template name="PackageClassTree">
						<xsl:with-param name="package" select="current()"></xsl:with-param>
						<xsl:with-param name="classes" select="$classes"></xsl:with-param>
						<!--xsl:with-param name="sublevelClasses" select="current()/child::Classifier[@type='Class' or @type='Struct'][Extends]"></xsl:with-param-->
						<xsl:with-param name="sublevelClasses" select="current()/child::Classifier[@type='Class' or @type='Struct'][not(count(Extends)=count(Extends/@doom))]"></xsl:with-param>
					</xsl:call-template>
					<p/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>

		<!-- Interface hierarchy -->
		<xsl:if test="$areInterfaces">
			<h2>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'interface_hierarchy'"></xsl:with-param>
			</xsl:call-template>
			</h2>
			<xsl:for-each select="//Package | //Model">
				<!--xsl:variable name="interfaces" select="current()/child::Classifier[@type='Interface'][not(Extends)]"></xsl:variable-->
				<xsl:variable name="interfaces" select="current()/child::Classifier[@type='Interface'][count(Extends)=count(Extends/@doom)]"></xsl:variable>
				<xsl:if test="$interfaces">
					<xsl:call-template name="PackageInterfaceTree">
						<xsl:with-param name="package" select="current()"></xsl:with-param>
						<xsl:with-param name="interfaces" select="$interfaces"></xsl:with-param>
						<!--xsl:with-param name="sublevelInterfaces" select="current()/child::Classifier[@type='Interface'][Extends]"></xsl:with-param-->
						<xsl:with-param name="sublevelInterfaces" select="current()/child::Classifier[@type='Interface'][not(count(Extends)=count(Extends/@doom))]"></xsl:with-param>
					</xsl:call-template>
					<p/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<hr/>
		<xsl:if test="$navbar_param">
			<xsl:call-template name="OverViewTreeNavBar">
			</xsl:call-template>
		</xsl:if>
		<br/>
		<p/>
		<xsl:value-of select="$bottom_param"></xsl:value-of>
	</xsl:template>
</xsl:stylesheet>
